/* ============ */
/* gencpnda.c	*/
/* ============ */
#include <miscdefs.h>
#include <cupndefs.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

static
UCHAR	ChkBits[4096];

/* ==================================================================== */
/* GenCouponData - Generates One Coupon Collector's Segment             */
/* ==================================================================== */
UINT
GenCouponData(COUPON_DATA_STRU * CouponData)
{
    int     Next, NumFound, NumGen;
    int     RandFound = FALSE;

    memset(ChkBits, 0, sizeof(ChkBits));

    NumFound = 0;
    NumGen = 0;

    do
    {
	Next = CouponData->RandFun() % CouponData->SetSize;

	++NumGen;

	if (TestBit(ChkBits, Next) == 0)
	{
	    ++NumFound;
	    SetBit(ChkBits, Next, 1);
	}
    }
    while ((NumFound < CouponData->SetSize) &&
	NumGen <= CouponData->MaxGenPerSeg);

    if (NumFound >= CouponData->SetSize)
    {
	CouponData->CallStatusOK = TRUE;
    }
    else
    {
	CouponData->CallStatusOK = FALSE;

	fprintf(stderr,
	    "GenCouponData(): Failed to Collect a Segment\n");
	fprintf(stderr,"\t\tNumber Found = %d\n", NumFound);
    }

    return(NumGen);
}
